function [] = ordinalize_multi(varargin)
%This function allows the automation of ordinalize.  All you need to do is
%point first at a directory of avert files, e.g., files with ordials, and
%then a directory of aprop files, e.g., the files to be ordinalized.
%Synatax:   [] = ordinalize_multi('dir1','c:\...','files')
%Input:     'path1' = the directory where the ordinal files are.
%           'path2' =  the directory of the property files are.
%           'filter' = filter for distance, default  = 0 or off
%Output:    none
[path1,path2,filter,flt_col,thresh] = parse(varargin);  %parse the input

%Grab and parse the two directories
ord_dir = dir(path1);  %grab the directory information
idx = [ord_dir.isdir];   %grab all of the isdir numbers
curr_names = {ord_dir.name};   %grab the all of the names
filenames = curr_names(~idx);   %grab the files first
filenames = findfiletype(filenames,'.csv');  %only csvs
%we are now going to assume the file name is a specific format, the fixed
%filename format is why this is in the experimental/restricted section.
%The format is: 11_avert_PSD95_xxxx.csv.
%First we will take the first two numbers of each file
for i = 1:size(filenames,2)
    datasetnum{i} = filenames{i}(1:2);
end

%Now parse the property files directory
prop_dir = dir(path2);  %grab the directory information
idx = [prop_dir.isdir];   %grab all of the isdir numbers
curr_names2 = {prop_dir.name};   %grab the all of the names
filenames2 = curr_names2(~idx);   %grab the files first
filenames2 = findfiletype(filenames2,'.csv');  %only csvs
%we are now going to assume the file name is a specific format, the fixed
%filename format is why this is in the experimental/restricted section.
%The format is: 11_aprop_SYN_xxxx.csv.
%Now bin file names according to their datasets, cell arrays of cell arrays
for k = 1:size(datasetnum,2)    %match each dataset
    set_tmp = [];  %initiate
    for j = 1:size(filenames2,2)  %go through files
        if strcmp(datasetnum{k},filenames2{j}(1:2))  %if there is a match you are in the same dataset
            set_tmp = horzcat(set_tmp,filenames2(j));
        end
    end
    dataset{k} = set_tmp;
end

%OK now call ordinalize
for l = 1:size(dataset,2)  %ordinalize each dataset
    ordinalize('path1',[path1,filesep],'path2',[path2,filesep],'file1',filenames{l},...
        'file2',dataset{l},'filter',filter);
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [path1,path2,filter,flt_col,thresh] = parse(input)

path1 = [];
path2 = [];
filter = 0;
flt_col = 4;
thresh = 5;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'path1'
                    path1 = input{1,i+1};
                case 'path2'
                    path2 = input{1,i+1};
                case 'filter'
                    filter = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if isempty(path1)  %get the avert directory
    path1 = uigetdir2('','Directory where your ordinal files are');
end
if isempty(path2)  %get the aprop directory
    path2 = uigetdir2('','Directory where your property files are');
end